<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Dtos\Common\UserIdsDTO;
use Erlage\Photogram\Data\Dtos\User\UserDisplayImageDTO;
use Erlage\Photogram\Data\Dtos\User\UserMetaPushSettingsDTO;

trait TraitUserSetters
{
    use TraitUserProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setEmail(string $email)
    {
        $this -> email = $email;

        return $this;
    }

    /**
     * @return static 
     */
    public function setUsername(string $username)
    {
        $this -> username = $username;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPassword(string $password)
    {
        $this -> password = $password;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayName(string $displayName)
    {
        $this -> displayName = $displayName;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayBio(string $displayBio)
    {
        $this -> displayBio = $displayBio;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayImage(UserDisplayImageDTO $displayImage)
    {
        $this -> displayImage = $displayImage;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayWeb(string $displayWeb)
    {
        $this -> displayWeb = $displayWeb;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaAccess(string $metaAccess)
    {
        $this -> metaAccess = $metaAccess;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaIsPrivate(string $metaIsPrivate)
    {
        $this -> metaIsPrivate = $metaIsPrivate;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaIsEmailVerified(string $metaIsEmailVerified)
    {
        $this -> metaIsEmailVerified = $metaIsEmailVerified;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaPushSettings(UserMetaPushSettingsDTO $metaPushSettings)
    {
        $this -> metaPushSettings = $metaPushSettings;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaLastActive(string $metaLastActive)
    {
        $this -> metaLastActive = $metaLastActive;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCachePostsCount(string $cachePostsCount)
    {
        $this -> cachePostsCount = $cachePostsCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheFollowersCount(string $cacheFollowersCount)
    {
        $this -> cacheFollowersCount = $cacheFollowersCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheFollowingsCount(string $cacheFollowingsCount)
    {
        $this -> cacheFollowingsCount = $cacheFollowingsCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheBlockedUserIds(UserIdsDTO $cacheBlockedUserIds)
    {
        $this -> cacheBlockedUserIds = $cacheBlockedUserIds;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
